<?php 
require_once("config/configDB.php"); 
//session_start();
require "userPermission.php";
require 'financial_year_calculation.php';
?>

<!DOCTYPE html>
<html>
<head>
    <?php 
        require 'meta.php';  
        require 'header.php'; 
    ?>
</head>
<body>
    <?php require 'menu.php' ?>

<div class="container-fluid text-right col-sm-12 dashboard-add">  
<div class="col-sm-12 "> <h3 class="text-center"><strong>Vehicle Master</strong></h3></div>
<?php if($vehicleMaster_Add==1) {  ?>  
<a href="vehicleMasterAdd.php" class="btn btn-primary">Add</a>

<?php } ?>
</div>

<div class="container col-sm-12 ">
    <div class="datatable-header ">
        <div class="col-sm-12 box-title"><strong>Manage your vehicle master</strong></div>
        <table id="vehicleMasterDashboard" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" style="width:100%" >
            <thead>
                <tr>				
                    <!-- <th>ID</th> -->
                    <th>Vehicle Name</th>
                    <th>Vehicle Type</th> 
                    <th>Purchase Date</th> 
                    <th>Ownership</th> 
                    <th>Model</th>                    
                    <th>Action</th>
                </tr>
            </thead>
            <tbody></tbody>
           
        </table>
    </div>

</div>



    <?php require 'footer.php' ?>
    <script type="text/javascript">var base_url = "<?= $base_url ?>";</script>
    <script>
    
$(document).ready(function() {
			   var dataTable =  $('#vehicleMasterDashboard').DataTable( {
                    columnDefs: [{ "orderable": false, "targets": 5 } ],
			   	    responsive: {
					details: {
					    renderer: function ( api, rowIdx ) {
						var data = api.cells( rowIdx, ':hidden' ).eq(0).map( function ( cell ) {
						    var header = $( api.column( cell.column ).header() );
						    return  '<p style="color:#00A">'+header.text()+' : '+api.cell( cell ).data()+'</p>';
						} ).toArray().join('');
 
						return data ?    $('<table/>').append( data ) :    false;
					    }
					}
				    },
			   	processing: true,
				serverSide: true,				
                // aaSorting: [[0, 'desc']],
				//ajax: "test.js", // json datasource
				ajax: {
                    url : "vehicleMastergriddata.php",
                    type: 'POST',
                    data:  {
                        userpermissionEdit   : <?php echo $vehicleMaster_Edit; ?>,
                        userpermissionDelete : <?php echo $vehicleMaster_Delete; ?>
                }
                }
			    } );
			} );

function ConfirmvehicleMasterDelete(vehicleid) {
    //alert(vehicleid);
    if(confirm('Are you sure?'))    
    {           
        console.log("Data has been Delected ");
        $.ajax({
            url: base_url+'vehicleMasterDelete.php?vehicleid='+vehicleid,     
            dataType: "json",   
            type: 'GET',    
            success: function(data) {
                console.log("Data has been Delected "); 
                //window.location.href = "vehicleMasterDashboard.php";       
            },
            error: function() {             
                console.log('An error has occurred');               
            }                   
        }); 
    }
     window.location.href = "vehicleMasterDashboard.php";
}

</script>
</body>
</html>