<?php 

require_once("config/configDB.php"); 
require "financial_year_calculation.php";
require "userPermission.php";
require "inDieselProFetchData.php";

?>
<!DOCTYPE html>
<html>
<head>
    <?php 
      require 'meta.php'; 
      require 'header.php'; 
    ?>
</head>
<body>
  <?php require 'menu.php' ?>
  <div class="container-fluid">
    <h3 class="text-center"><strong>Bunk Diesel Details</strong></h3>
    <form class="form-horizontal" action="inDieselProInsert.php" method="post" id="inDieselProInvoice">
      <div class="col-sm-12 row">
      <div class=" col-sm-1"></div>
        <div class=" col-sm-3 form-group">
          <label class="control-label">Invoice No</label>
          <input class="form-control input-lg" type="text" name="invoice" value="<?php echo $invoice_count; ?>" readonly >
        </div>
        
        <div class="col-sm-3 form-group">
          <label class="control-label">Date</label>
          <input class="form-control input-lg datepicker-internalprodate"  type="text" name="internalprodate" autocomplete="off" readonly>
        </div>
        <div class="col-sm-3 form-group">
          <label for="inputlg">Bunk Name </label>
          <input class="form-control input-lg" type="text" value="ABC Bunk" >
        </div>
       
        
      </div>

      <div class=" col-sm-12 row"><br></div>
      <div class=" col-sm-12 row">
        <div class=" col-sm-1"></div>
        <div class=" col-sm-3 form-group">
          <label class="control-label">Vehicle No</label>
          <select class="form-control input-lg selectpicker select-trip-vehicle" data-show-subtext="true" data-live-search="true" name="vehicleno">
            <!--<option disabled selected>Please Select Vehicle</option>-->
            <?php   echo $sqlVehicleNo;   ?>
          </select> 
        </div>
        <div class="col-sm-2 form-group">
          <label class="control-label">Odometer(KM)</label>
          <input class="form-control input-lg odometerkm"  type="text" name="odometerkm" placeholder="Enter odometers" value="1234" >
        </div>
		
		<div class="col-sm-2 form-group">
          <label class="control-label">Litres</label>
          <input class="form-control input-lg" type="text" name="eqty" placeholder="Enter Diesel Quality" value="200">
        </div>
		
        <div class="col-sm-2 form-group">
          <label class="control-label">Amount</label>
          <input class="form-control input-lg odometerhours" type="text" name="odometerhours" placeholder="Enter Amount" value="1400" >
        </div>
        
       
      </div>
      
      
      <div class=" col-sm-12 row"><br></div>

    <div class="form-group">        
      <div class="col-sm-12 text-center">
        <button type="submit" class="btn btn-default btn-lg">Save</button>
      </div>
    </div>
    </form>   
  </div>
  <?php require 'footer.php' ?>
 
  <script type="text/javascript">var base_url = "<?= $base_url ?>";</script>
  
  <script type="text/javascript" src="inDieselProScript.js"></script>
<script>
	$(document).ready(function(){
	  var date_input=$('input[name="internalprodate"]'); //our date input has the name "date"
		var container=$('form >  .datepicker-internalprodate').length>0 ? $('form > .datepicker-internalprodate').parent() : "body";
		date_input.datepicker({
			  format: 'dd-mm-yyyy',
        container: container,
			  todayHighlight: true,
			  autoclose: true,
    });
    $('input[name="internalprodate"]').datepicker( "setDate", new Date());      
    $('#inDieselProInvoice').bootstrapValidator({
        // To use feedback icons, ensure that you use Bootstrap v3.1.0 or later
        feedbackIcons: {
            valid: 'glyphicon glyphicon-ok',
            invalid: 'glyphicon glyphicon-remove',
            validating: 'glyphicon glyphicon-refresh'
        },
        fields: {
          invoice: {
                message: 'The invoice number is not valid',
                validators: {
                    notEmpty: {
                        message: 'The invoice number is required and cannot be empty'
                    }
                }
            },
            internalprodate: {
                message: 'The invoice date is not valid',
                validators: {
                    notEmpty: {
                        message: 'The invoice date is required and cannot be empty'
                    }
                }
          },  
          vehicleno: {
                message: 'The vehicle number is not valid',
                validators: {
                    notEmpty: {
                        message: 'The vehicle number is required and cannot be empty'
                    }
                }
            },
            eqty: {
                message: 'The litres is not valid',
                validators: {
                    notEmpty: {
                        message: 'The litres is required and cannot be empty'
                    },
                    regexp: {
                        regexp: /^[0-9]+$/,
                        message: 'The supplier invoice amount can only consist of number'
                    }
                }
            },
            odometer: {
                message: 'The odometer is not valid',
                validators: {
                    regexp: {
                        regexp: /^[0-9]+$/,
                        message: 'The supplier invoice amount can only consist of number'
                    }
                }
            }
        }
    });
    

	});
</script>
</body>
</html>