<?php 
require_once("config/configDB.php"); 
//session_start();
require "userPermission.php";
require 'financial_year_calculation.php';
?>

<!DOCTYPE html>
<html>
<head>
    <?php 
        require 'meta.php';  
        require 'header.php'; 
    ?>
</head>
<body>
    <?php require 'menu.php' ?>
    <div class="col-sm-12 "> <h3 class="text-center"><strong>External Diesel Unfilling  </strong></h3></div>
<div class="container-fluid text-right col-sm-12 dashboard-add">  
<?php if($exDieselPro_Add==1) {  ?>  
<a href="exDieselProAdd.php" class="btn btn-primary">Add</a>

<?php } ?>
</div>
<div class="container col-sm-12 ">
    <div class="datatable-header ">
        <div class="col-sm-12 box-title"><strong>Manage your External diesel production</strong></div>
        <table id="exDieselProDashboard" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" >
            <thead>
                <tr>				
                    <th>ID</th>
                    <th>Date</th>
                    <th>Supplier</th>
                    <th>Vehicle</th>
                    <th>odometer (KM)</th>
                    <th>Litres</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody></tbody>
           
        </table>
    </div>

</div>
    <?php require 'footer.php' ?>
    <script type="text/javascript">var base_url = "<?= $base_url ?>";</script>
    <script>
    
$(document).ready(function() {
			   var dataTable =  $('#exDieselProDashboard').DataTable( {
                columnDefs: [{ "orderable": false, "targets": 3 } ],
			   	    responsive: {
					details: {
					    renderer: function ( api, rowIdx ) {
						var data = api.cells( rowIdx, ':hidden' ).eq(0).map( function ( cell ) {
						    var header = $( api.column( cell.column ).header() );
						    return  '<p style="color:#00A">'+header.text()+' : '+api.cell( cell ).data()+'</p>';
						} ).toArray().join('');
 
						return data ?    $('<table/>').append( data ) :    false;
					    }
					}
				    },
			   	processing: true,
				serverSide: true,				aaSorting: [[0, 'desc']],
				//ajax: "test.js", // json datasource
				ajax: {
                    url : "exDieselProgriddata.php",
                    type: 'POST',
                    data:  {
                        userpermissionEdit   : <?php echo $exDieselPro_Edit; ?>,
                        userpermissionDelete : <?php echo $exDieselPro_Delete; ?>
                }
                }
			    } );
			} );

function ConfirmexDieselProDelete(brandid) {
    //alert(brandid);
    if(confirm('Are you sure?'+base_url))    
    {           
        console.log("Data has been Delected "+base_url);
        $.ajax({
            url: base_url+'exDieselProDelete.php?brandid='+brandid,     
            dataType: "json",   
            type: 'GET',    
            success: function(data) {
                console.log("Data has been Delected "); 
                //window.location.href = "exDieselProDashboard.php";       
            },
            error: function() {             
                console.log('An error has occurred');               
            }                   
        });
        window.location.href = "exDieselProDashboard.php";     
    }
     
}

</script>
</body>
</html>