<?php 
require_once("config/configDB.php"); 
//session_start();
require "userPermission.php";
require 'financial_year_calculation.php';
?>

<!DOCTYPE html>
<html>
<head>
    <?php 
        require 'meta.php';  
        require 'header.php'; 
    ?>
</head>
<body>
    <?php require 'menu.php' ?>
    <div class="col-sm-12 "> <h3 class="text-center"><strong>Labour Employee Details</strong></h3></div>
<div class="container-fluid text-right col-sm-12 dashboard-add">  
<?php if($accLabour_Add==1) {  ?>  
<a href="accLabourAdd.php" class="btn btn-primary">Attendance</a>

<?php } ?>
</div>
<div class="container col-sm-12 ">
    <div class="datatable-header ">
        <div class="col-sm-12 box-title"><strong>Manage your labour Employee</strong></div>
        <table id="accLabourDashboard" class="table table-striped table-bordered dt-responsive wrap" cellspacing="0" >
            <thead>
                <tr>				
                    <!-- <th>ID</th> -->
                    <th>Attendance Date</th>
                    <th>Worked Employee List</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody></tbody>
           
        </table>
    </div>

</div>
<div class="container col-sm-12 "><br><br></div>
<div class=" col-sm-2">
    <label>From Date</label>
    <input type="text" class="form-control input-lg" id="fromDate" autocomplete="off">
   
</div>
<div class=" col-sm-2">
    <label>To Date</label>
    <input type="text" class="form-control input-lg" id="toDate" autocomplete="off">
    
</div>
<div class=" col-sm-1" style="padding-top: 24px;">
    <button type="button" class="btn btn-primary btn-lg datewise-submit-apply">Apply</button>
</div>

<div class="container col-sm-12 "><br></div>
<div class="container col-sm-12 ">
    <div class="datatable-header ">
        <div class="col-sm-12 box-title"><strong>Manage your labour Employee salary</strong></div>
        <table id="accLabourSalaryDashboard" class="table table-striped table-bordered dt-responsive wrap" cellspacing="0" >
            <thead>
                <tr>				
                    <th>Labour Name </th>
                    <th>Total Worked shift </th>
                    <th>Total Worked Extra </th>
                    <th>Shift Amount</th>
                    <th>Extra Hours Amount</th>
                    <th>Salary</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody></tbody>
           
        </table>
    </div>

</div>
    <?php require 'footer.php' ?>
    <script type="text/javascript">var base_url = "<?= $base_url ?>";</script>
    <script type="text/javascript" src="js/plugin/jquery-ui.min.js"></script>
    <script>
    
$(document).ready(function() {
			   var dataTable =  $('#accLabourDashboard').DataTable( {
                columnDefs: [{ "orderable": false, "targets": 3 } ],
			   	    responsive: {
					details: {
					    renderer: function ( api, rowIdx ) {
						var data = api.cells( rowIdx, ':hidden' ).eq(0).map( function ( cell ) {
						    var header = $( api.column( cell.column ).header() );
						    return  '<p style="color:#00A">'+header.text()+' : '+api.cell( cell ).data()+'</p>';
						} ).toArray().join('');
 
						return data ?    $('<table/>').append( data ) :    false;
					    }
					}
				    },
			   	processing: true,
				serverSide: true,				aaSorting: [[0, 'desc']],
				//ajax: "test.js", // json datasource
				ajax: {
                    url : "accLabourgriddata.php",
                    type: 'POST',
                    data:  {
                        userpermissionEdit   : <?php echo $accLabour_Edit; ?>,
                        userpermissionDelete : <?php echo $accLabour_Delete; ?>
                }
                }
                } );
                //accLabourSalaryDashboard
                var dataTable =  $('#accLabourSalaryDashboard').DataTable( {
                //columnDefs: [{ "orderable": false, "targets": 3 } ],
			   	    responsive: {
					details: {
					    renderer: function ( api, rowIdx ) {
						var data = api.cells( rowIdx, ':hidden' ).eq(0).map( function ( cell ) {
						    var header = $( api.column( cell.column ).header() );
						    return  '<p style="color:#00A">'+header.text()+' : '+api.cell( cell ).data()+'</p>';
						} ).toArray().join('');
 
						return data ?    $('<table/>').append( data ) :    false;
					    }
					}
				    },
			   	processing: true,
				serverSide: true,				aaSorting: [[0, 'desc']],
				//ajax: "test.js", // json datasource
				ajax: {
                    url : "accLabourSalarygriddata.php",
                    type: 'POST',
                    data:  {
                        SalaryfromDate    : $('input#fromDate').val(),
                        SalarytoDate      : $('input#toDate').val()
                }
                }
                } );

            $("#fromDate").datepicker({
                
                dateFormat: 'dd-mm-yy',
                onSelect: function (dateStr) {
                    var min = $(this).datepicker('getDate'); // Get selected date
                    $("#toDate").datepicker('option', 'minDate', min || '0'); // Set other min, default to today
                }
            });

            $("#toDate").datepicker({
                minDate: '1',
                dateFormat: 'dd-mm-yy',
                onSelect: function (dateStr) {
                    var max = $(this).datepicker('getDate'); // Get selected date

                    $('#datepicker').datepicker('option', 'maxDate', max || '+1Y+6M'); // Set other max, default to +18 months

                    
                }
            });  
      
    $('body').on('click','button.datewise-submit-apply',function(){
        var fromDate = $('input#fromDate').val();
        var toDate = $('input#toDate').val();
        
        var dataTable =  $('#accLabourSalaryDashboard').DataTable( {
                responsive: {
                    details: {
                     renderer: function ( api, rowIdx ) {
                     var data = api.cells( rowIdx, ':hidden' ).eq(0).map( function ( cell ) {
                         var header = $( api.column( cell.column ).header() );
                         return  '<p style="color:#00A">'+header.text()+' : '+api.cell( cell ).data()+'</p>';
                     } ).toArray().join('');        
                     return data ?    $('<table/>').append( data ) :    false;
                     }
                    }
                },
                processing: true,
                serverSide: true,				
                aaSorting: [[0, 'desc']],
                destroy: true,
                ajax: {
                    url : "accLabourSalarygriddata.php",
                    type: 'POST',
                    data:  {
                        SalaryfromDate    : fromDate,
                        SalarytoDate      : toDate
                    }
                }
            });

  
    });   
            
			} );


function ConfirmaccLabourDelete(brandid) {
    //alert(brandid);
    if(confirm('Are you sure?'+base_url))    
    {           
        console.log("Data has been Delected "+base_url);
        $.ajax({
            url: base_url+'accLabourDelete.php?brandid='+brandid,     
            dataType: "json",   
            type: 'GET',    
            success: function(data) {
                console.log("Data has been Delected "); 
                //window.location.href = "accLabourDashboard.php";       
            },
            error: function() {             
                console.log('An error has occurred');               
            }                   
        });
        window.location.href = "accLabourDashboard.php";     
    }
     
}
function ConfirmlaboursPaySalary(eid) {
    if(confirm('Are you sure ?'))    
    {           
        //console.log("Data has been Delected "+eid);
        var fromDate = $('input#fromDate').val();
        var toDate = $('input#toDate').val();
        $.ajax({
            url: base_url+'accLabourpaysalary.php?eid='+eid+'&SalaryfromDate='+fromDate+'&SalarytoDate='+toDate,     
            dataType: "json",   
            type: 'GET',    
            success: function(data) {
                console.log("Data has been Delected "); 
                //window.location.href = "accLabourDashboard.php";       
            }                 
        });
        window.location.href = "accLabourDashboard.php";     
    }
}

</script>
</body>
</html>