<?php 
require_once("config/configDB.php"); 
//session_start();
require "userPermission.php";
require 'financial_year_calculation.php';
?>

<!DOCTYPE html>
<html>
<head>
    <?php 
        require 'meta.php';  
        require 'header.php'; 
    ?>
</head>
<body>
    <?php require 'menu.php' ?>
    <div class="col-sm-12 "> <h3 class="text-center"><strong>Labour Advance Details</strong></h3></div>
<div class="container-fluid text-right col-sm-12 dashboard-add">  
<?php if($accEmpAdv_Add==1) {  ?>  
<a href="accLabourAdvAdd.php" class="btn btn-primary">Advance</a>

<?php } ?>
</div>
<div class="container col-sm-12 ">
    <div class="datatable-header ">
        <div class="col-sm-12 box-title"><strong>Manage your Employee Advance</strong></div>
        <table id="accEmpAdvDashboard" class="table table-striped table-bordered dt-responsive wrap" cellspacing="0" >
            <thead>
                <tr>				
                    <!-- <th>ID</th> -->
                    <th>Advance Date</th>
                    <th>Worked Employee List</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody></tbody>
           
        </table>
    </div>

</div>
<div class="container col-sm-12 "><br><br></div>
<div class=" col-sm-2">
    <label>From Date</label>
    <input type="text" class="form-control input-lg" id="fromDate" autocomplete="off">
   
</div>
<div class=" col-sm-2">
    <label>To Date</label>
    <input type="text" class="form-control input-lg" id="toDate" autocomplete="off">
    
</div>
<div class=" col-sm-1" style="padding-top: 24px;">
    <button type="button" class="btn btn-primary btn-lg datewise-submit-apply">Apply</button>
</div>

<div class="container col-sm-12 "><br></div>
<div class="container col-sm-12 ">
    <div class="datatable-header ">
        <div class="col-sm-12 box-title"><strong>Manage your Employee Advance</strong></div>
        <table id="accEmpAdvSalaryDashboard" class="table table-striped table-bordered dt-responsive wrap" cellspacing="0" >
            <thead>
                <tr>				
                    <th>Employee Name </th>
                    <th>Total Advance Amount </th>
                    <th>Total Collection Amount </th>
                    <th>Total Pending Amount </th>
                    <th>Action </th>

                   
                </tr>
            </thead>
            <tbody></tbody>
           
        </table>
    </div>

</div>
    <?php require 'footer.php' ?>
    <script type="text/javascript">var base_url = "<?= $base_url ?>";</script>
    <script type="text/javascript" src="js/plugin/jquery-ui.min.js"></script>
    <script>
    
$(document).ready(function() {
			   var dataTable =  $('#accEmpAdvDashboard').DataTable( {
                columnDefs: [{ "orderable": false, "targets": 3 } ],
			   	    responsive: {
					details: {
					    renderer: function ( api, rowIdx ) {
						var data = api.cells( rowIdx, ':hidden' ).eq(0).map( function ( cell ) {
						    var header = $( api.column( cell.column ).header() );
						    return  '<p style="color:#00A">'+header.text()+' : '+api.cell( cell ).data()+'</p>';
						} ).toArray().join('');
 
						return data ?    $('<table/>').append( data ) :    false;
					    }
					}
				    },
			   	processing: true,
				serverSide: true,				aaSorting: [[0, 'desc']],
				//ajax: "test.js", // json datasource
				ajax: {
                    url : "accLabourAdvgriddata.php",
                    type: 'POST',
                    data:  {
                        userpermissionEdit   : <?php echo $accEmpAdv_Edit; ?>,
                        userpermissionDelete : <?php echo $accEmpAdv_Delete; ?>
                }
                }
                } );
                //accEmpAdvSalaryDashboard
                var dataTable =  $('#accEmpAdvSalaryDashboard').DataTable( {
                //columnDefs: [{ "orderable": false, "targets": 3 } ],
			   	    responsive: {
					details: {
					    renderer: function ( api, rowIdx ) {
						var data = api.cells( rowIdx, ':hidden' ).eq(0).map( function ( cell ) {
						    var header = $( api.column( cell.column ).header() );
						    return  '<p style="color:#00A">'+header.text()+' : '+api.cell( cell ).data()+'</p>';
						} ).toArray().join('');
 
						return data ?    $('<table/>').append( data ) :    false;
					    }
					}
				    },
			   	processing: true,
				serverSide: true,				aaSorting: [[0, 'desc']],
				//ajax: "test.js", // json datasource
				ajax: {
                    url : "accEmpAdvSalarygriddata.php",
                    type: 'POST',
                    data:  {
                        SalaryfromDate    : $('input#fromDate').val(),
                        SalarytoDate      : $('input#toDate').val()
                }
                }
                } );

            $("#fromDate").datepicker({
                
                dateFormat: 'yy-mm-dd',
                onSelect: function (dateStr) {
                    var min = $(this).datepicker('getDate'); // Get selected date
                    $("#toDate").datepicker('option', 'minDate', min || '0'); // Set other min, default to today
                }
            });

            $("#toDate").datepicker({
                minDate: '1',
                dateFormat: 'yy-mm-dd',
                onSelect: function (dateStr) {
                    var max = $(this).datepicker('getDate'); // Get selected date

                    $('#datepicker').datepicker('option', 'maxDate', max || '+1Y+6M'); // Set other max, default to +18 months

                    
                }
            });  
      
    $('body').on('click','button.datewise-submit-apply',function(){
        var fromDate = $('input#fromDate').val();
        var toDate = $('input#toDate').val();
        
        var dataTable =  $('#accEmpAdvSalaryDashboard').DataTable( {
                responsive: {
                    details: {
                     renderer: function ( api, rowIdx ) {
                     var data = api.cells( rowIdx, ':hidden' ).eq(0).map( function ( cell ) {
                         var header = $( api.column( cell.column ).header() );
                         return  '<p style="color:#00A">'+header.text()+' : '+api.cell( cell ).data()+'</p>';
                     } ).toArray().join('');        
                     return data ?    $('<table/>').append( data ) :    false;
                     }
                    }
                },
                processing: true,
                serverSide: true,				
                aaSorting: [[0, 'desc']],
                destroy: true,
                ajax: {
                    url : "accEmpAdvSalarygriddata.php",
                    type: 'POST',
                    data:  {
                        SalaryfromDate    : fromDate,
                        SalarytoDate      : toDate
                    }
                }
            });

  
    });   
            
			} );


function ConfirmaccEmpAdvDelete(brandid) {
    //alert(brandid);
    if(confirm('Are you sure?'+base_url))    
    {           
        console.log("Data has been Delected "+base_url);
        $.ajax({
            url: base_url+'accEmpAdvDelete.php?brandid='+brandid,     
            dataType: "json",   
            type: 'GET',    
            success: function(data) {
                console.log("Data has been Delected "); 
                //window.location.href = "accEmpAdvDashboard.php";       
            },
            error: function() {             
                console.log('An error has occurred');               
            }                   
        });
        window.location.href = "accEmpAdvDashboard.php";     
    }
     
}
function ConfirmEmpAdvsPaySalary(eid) {
    if(confirm('Are you sure ?'))    
    {           
        //console.log("Data has been Delected "+eid);
        var fromDate = $('input#fromDate').val();
        var toDate = $('input#toDate').val();
        $.ajax({
            url: base_url+'accEmpAdvpaysalary.php?eid='+eid+'&SalaryfromDate='+fromDate+'&SalarytoDate='+toDate,     
            dataType: "json",   
            type: 'GET',    
            success: function(data) {
                console.log("Data has been Delected "); 
                //window.location.href = "accEmpAdvDashboard.php";       
            }                 
        });
        window.location.href = "accEmpAdvDashboard.php";     
    }
}

</script>
</body>
</html>