<?php 

require_once("config/configDB.php"); 
require "userPermission.php";

$sql_InvoiceQuery   = mysqli_query($conn,"SELECT count(*) as code FROM labours_master");
$rowInvoiceCount    = mysqli_fetch_array($sql_InvoiceQuery,MYSQLI_ASSOC);
$code_count      = $rowInvoiceCount['code']+1;

?>

<!DOCTYPE html>
<html>
<head>
    <?php 
      require 'meta.php'; 
      require 'header.php'; 
    ?>

</head>
<body>
    <?php require 'menu.php' ?>
<div class="container-fluid">
<h2 class="text-center">labours Master Details</h2><br>
    <form class="form-horizontal" action="laboursMasterInsert.php" method="post" id="laboursMasterForm">
    <div class="form-group">
      <label class="control-label col-sm-2" for="email">labours Name *</label>
      <div class="col-sm-9">
        <input type="text" class="form-control input-lg" placeholder="Enter labours Name" name="laboursname" autocomplete="off" required > 
      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-sm-2" for="email"> labours Code *</label>
        <div class="col-sm-4">
          <input type="text" class="form-control input-lg" placeholder="Enter labours Code" name="labourscode" autocomplete="off" value="<?php echo "EMPLABR-".$code_count; ?>" required readonly>
        </div> 
    </div>
    <div class="form-group">
      <label class="control-label col-sm-2" for="email">Address </label>
      <div class="col-sm-4">
        <textarea  class="form-control input-lg" placeholder="Enter Address" name="address" rows="4"></textarea>
      </div>
    </div>
    
    <div class="form-group">
    
    <label class="control-label col-sm-2" for="email">Mobile *</label>
      <div class="col-sm-4">
        <input type="number" class="form-control input-lg" placeholder="Enter mobile Number" name="mobile" autocomplete="off" required >
      </div>
     
    </div>
    <div class="form-group">
    
    <label class="control-label col-sm-2" for="email">Shift Working Amount</label>
      <div class="col-sm-4">
        <input type="number" class="form-control input-lg" placeholder="Enter Shift Working Amount" name="shiftworkamt" autocomplete="off" required >
      </div>
     
    </div>
    <div class="form-group">
    
    <label class="control-label col-sm-2" for="email">Extra Hours Amount</label>
      <div class="col-sm-4">
        <input type="number" class="form-control input-lg" placeholder="Enter Extra Hours Amount" name="extrahoursamt" autocomplete="off" required >
      </div>
     
    </div>
    
    <div class="form-group">
    
    <label class="control-label col-sm-2" for="email">Emp Work Location</label>
      <div class="col-sm-4">
       <select class="form-control" name="work_location" required>
       <option value="">Select Work Location</option>
       <option>Quarry</option>
       <option>Crusher</option>
       <option>RMC</option>
       <option>Transport</option>
       </select>
      </div>
     
    </div>

    <div class="form-group">        
      <div class="col-sm-12 text-center">
        <button type="submit" class="btn btn-primary btn-lg">Save</button>
      </div>
    </div>
  </form>   
</div>


    <?php require 'footer.php' ?>
    <script>
      $('#laboursMasterForm').bootstrapValidator({
        // To use feedback icons, ensure that you use Bootstrap v3.1.0 or later
        feedbackIcons: {
            valid: 'glyphicon glyphicon-ok',
            invalid: 'glyphicon glyphicon-remove',
            validating: 'glyphicon glyphicon-refresh'
        },
        fields: {
          laboursname: {
                message: 'The labours name is not valid',
                validators: {
                    notEmpty: {
                        message: 'The labours name is required and cannot be empty'
                    }
                }
            },
          labourscode: {
              validators: {
                  notEmpty: {
                        message: 'The labours code is required and cannot be empty'
                  }
              }
          },
          mobile: {
                message: 'The mobile is not valid',
                validators: {
                    notEmpty: {
                        message: 'The mobile is required and cannot be empty'
                    },
                    stringLength: {
                        min: 10,
                        max: 10,
                        message: 'The mobile must be more than 6 and less than 30 characters long'
                    },
                    regexp: {
                        regexp: /^[0-9]+$/,
                        message: 'The mobile can only consist of number'
                    },
                }
          },
          shiftworkamt: {
                
                validators: {
                    notEmpty: {
                        message: 'The shift work amount is required and cannot be empty'
                    },
                    regexp: {
                        regexp: /^[0-9]+$/,
                        message: 'The only consist of number'
                    },
                }
          },
          extrahoursamt: {
                
                validators: {
                    notEmpty: {
                        message: 'The Extra work amount is required and cannot be empty'
                    },
                    regexp: {
                        regexp: /^[0-9]+$/,
                        message: 'The only consist of number'
                    },
                }
          }

        }
    });
    
    </script>
</body>
</html>