<?php 

require_once("config/configDB.php"); 
require "userPermission.php";


?>

<!DOCTYPE html>
<html>
<head>
    
    <?php 
      require 'meta.php'; 
      require 'header.php'; 
    ?>
<script>

function validateForm() {
  var brandtype = document.forms["myForm"]["brandtype"].value;
 
  
  if (brandtype == "a") {
    alert("Brand must be filled out");
    return false;
  }
  
  
  
}

</script>
</head>
<body>
    <?php require 'menu.php' ?>
<div class="container-fluid">
    <h2 class="text-center">Add Brand Details</h2><br>
    <form class="form-horizontal" action="brandMasterInsert.php" method="post" id="brandMasterFrom" onsubmit="return validateForm()" name="myForm">
      <div class="form-group">        
        
        <label class="control-label col-sm-4">Brand Name </label>
        <div class="col-sm-4">
          <input type="text" class="form-control input-lg" placeholder="Enter brand name" name="brandname" autocomplete="off">
        </div>
        
      </div>
      <div class="form-group">        
        
        <label class="control-label col-sm-4">Item Type *</label>
        <div class="col-sm-4">
          <select class="form-control input-lg selectpicker" data-live-search="true" name="brandtype" id="brandtype">
            <option value="a">SELECT VEHICLE TYPE</option>
            <option value="transport">Transport Vehicle</option>
            <!--<option value="equipment">Equipment Vehicle</option>-->
            </select>
        </div>     
      
      </div>     
      
     <div class="form-group">        
      <div class="col-sm-12 text-center">
          <button type="submit" class="btn btn-primary btn-lg">Save</button>
      </div>
    </div>
  </form>   
</div>


  <?php require 'footer.php' ?>
  <script>
	$(document).ready(function(){
	  $('#brandMasterFrom').bootstrapValidator({
        // To use feedback icons, ensure that you use Bootstrap v3.1.0 or later
        feedbackIcons: {
            valid: 'glyphicon glyphicon-ok',
            invalid: 'glyphicon glyphicon-remove',
            validating: 'glyphicon glyphicon-refresh'
        },
        fields: {
          brandname: {
                message: 'The brand name is not valid',
                validators: {
                    notEmpty: {
                        message: 'The  brand name is required and cannot be empty'
                    }
                }
            },
            brandtype: {
                message: 'The brand type is not valid',
                validators: {
                    notEmpty: {
                        message: 'The brand type is required and cannot be empty'
                    }
                }
          }
        }
    });
    

	});
</script>


</body>
</html>